<?php 
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Portfolio.php";
    
    if(isset($_GET["id"])) {
        $idPortfolio = filter_input(INPUT_GET,"id", FILTER_SANITIZE_NUMBER_INT);
        $portfolio = new Portfolio($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $portfolio->caricaDatiDalDatabase();
    }
    else {
        $idPortfolio = 0;
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione portfolio</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Occorrenza creata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Occorrenza modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($portfolio) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($portfolio) ? $portfolio->getId() : "0")); ?>">
                                
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-12 col-md-6 d-md-flex">
                                            <h6 class="mt-2 mr-2">Portfolio:</h6>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($portfolio) ? $portfolio->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        <div class="col text-right">
                                            <a class="btn btn-outline-primary mt-2 mt-md-0" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button class="btn btn-primary mt-2 mt-md-0"><i class="fas fa-check"></i> Salva</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <label for="inputPassword3" >Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($portfolio) && $portfolio->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dal portfolio</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Elementi per riga</label>
                                            <select class="form-control" name="classeElementi">
                                                <?php
                                                    $arrayClassiElemento = array("portfolio col-12"=>1,"portfolio col-sm-6"=>2,"portfolio col-sm-6 col-md-4"=>3,"portfolio col-sm-6 col-md-4 col-lg-3"=>4,"portfolio col-sm-6 col-md-4 col-lg-3 col-xl-2"=>6);
                                                    foreach($arrayClassiElemento as $classe=>$numeroELementi) {
                                                        if(isset($portfolio) && $classe==$portfolio->getClasseElementi()) {
                                                            echo"<option value=\"$classe\" SELECTED>{$numeroELementi}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">{$numeroELementi}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Il numero di elementi visualizzati su una riga a risoluzione desktop</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Aspetto</label>
                                            <select class="form-control" name="aspetto">
                                                <?php
                                                    $arrayAspettiPortfolio = array("classico"=>"Classico","elenco"=>"Elenco");
                                                    foreach($arrayAspettiPortfolio as $classe=>$numeroELementi) {
                                                        if(isset($portfolio) && $classe==$portfolio->getAspetto()) {
                                                            echo"<option value=\"$classe\" SELECTED>{$numeroELementi}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">{$numeroELementi}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Scegli l'aspetto delle anteprime</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Aspect ratio anteprime</label>
                                            <select class="form-control" name="aspectRatio">
                                                <?php
                                                    $arrayAspectRatio = array("aspect-ratio-1-1"=>"1:1","aspect-ratio-4-3"=>"4:3","aspect-ratio-16-9"=>"16:9","aspect-ratio-3-4"=>"3:4","aspect-ratio-3-2"=>"3:2","aspect-ratio-8-5"=>"8:5","aspect-ratio-9-16"=>"9:16");
                                                    foreach($arrayAspectRatio as $classe=>$opzione) {
                                                        if(isset($portfolio) && $classe==$portfolio->getAspectRatio()) {
                                                            echo"<option value=\"$classe\" SELECTED>{$opzione}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">{$opzione}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Le proporzioni delle miniature di ciascun elemento</small>
                                        </div>
                                        
                                        <div class="col-md-6 form-group">
                                            <label class="d-block">Descrizione</label>
                                            <textarea class="form-control" name="descrizione" rows="2" aria-describedby="Descrizione" placeholder="Descrizione"><?php echo((isset($portfolio) ? $portfolio->getDescrizione() : "")) ?></textarea>
                                            <small class="form-text text-muted">Se inserita la descrizione comparirà subito sotto il titolo</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Etichetta "altri elementi"</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="etichettaAltriElementi" aria-describedby="Etichetta altri elementi" value="<?php echo((isset($portfolio) ? $portfolio->getEtichettaAltriElementi() : "")) ?>" placeholder="Etichetta altri elementi">
                                            <small class="form-text text-muted">Comparirà prima degli elementi correlati del portfolio</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Link torna al portfolio</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="linkPagina" aria-describedby="Link torna al portfolio" value="<?php echo((isset($portfolio) ? $portfolio->getLinkPagina() : "")) ?>" placeholder="Link torna al portfolio">
                                            <small class="form-text text-muted">Mostra un link alla pagina principale del portfolio</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Filtrabile</label>
                                            <input type="checkbox" class="js-switch" name="filtrabile" value="si" <?php echo((isset($portfolio) && $portfolio->getFiltrabile()=="si") ? "checked" : "") ?>>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Senza bordi</label>
                                            <input type="checkbox" class="js-switch" name="senzaBordi" value="si" <?php echo((isset($portfolio) && $portfolio->getSenzaBordi()=="si") ? "checked" : "") ?>>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Mostra nomi elementi</label>
                                            <input type="checkbox" class="js-switch"  name="mostraNomiElementi" value="si" <?php echo((isset($portfolio) && $portfolio->getMostraNomiElementi()=="si") ? "checked" : "") ?>>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Mostra immagine in evidenza nell'header</label>
                                            <input type="checkbox" class="js-switch"  name="mostraImmagineInEvidenza" value="si" <?php echo((isset($portfolio) && $portfolio->getMostraImmagineInEvidenza()=="si") ? "checked" : "") ?>>
                                        </div>
                                        
                                        <div id="localizzazionePortfolio" class="<?php echo((isset($portfolio) && $portfolio->getid()!=0) ? "col-12 mb-4" : "d-none") ?>">
                                            <hr>
                                            <h5>Localizzazione</h5>
                                           
                                            <div class="row row-cols-md-5">
                                                <div class="form-group col">
                                                    <label for="metadescription">Italiano</label>
                                                    <select name="traduzioneItaliano" class="selectpicker" data-width="100%" data-live-search="true" data-size="10">
                                                        <option value="-1">Nessuno</option>
                                                        <option value="0" <?php echo((isset($portfolio) && $portfolio->getTraduzioneItaliano()==0) ? "selected" : "")?>>Questa occorrenza</option>
                                                        <?php
                                                            $queryComponentiDaMostrare = "SELECT * FROM geec_portfolio  WHERE id != {$idPortfolio}";
                                                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                                            while($portfolioTmp = $risComponenti->fetch_assoc()) {
                                                                $selezionato = "";
                                                                if((isset($portfolio) && $portfolio->getTraduzioneItaliano()==$portfolioTmp["id"])) {
                                                                    $selezionato = "selected";
                                                                }
                                                                echo"<option value=\"{$portfolioTmp["id"]}\" $selezionato >{$portfolioTmp["nome"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                </div>

                                                <div class="form-group col">
                                                    <label for="metadescription">Inglese</label>
                                                    <select name="traduzioneInglese" class="selectpicker" data-width="100%" data-live-search="true" data-size="10">
                                                        <option value="-1">Nessuno</option>
                                                        <option value="0" <?php echo((isset($portfolio) && $portfolio->getTraduzioneInglese()==0) ? "selected" : "")?>>Questa occorrenza</option>
                                                        <?php
                                                            
                                                            $queryComponentiDaMostrare = "SELECT * FROM geec_portfolio  WHERE id != {$idPortfolio}";
                                                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                                            while($portfolioTmp = $risComponenti->fetch_assoc()) {
                                                                $selezionato = "";
                                                                if((isset($portfolio) && $portfolio->getTraduzioneInglese()==$portfolioTmp["id"])) {
                                                                    $selezionato = "selected";
                                                                }
                                                                echo"<option value=\"{$portfolioTmp["id"]}\" $selezionato >{$portfolioTmp["nome"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group col">
                                                    <label for="metadescription">Tedesco</label>
                                                    <select name="traduzioneTedesco" class="selectpicker" data-width="100%" data-live-search="true" data-size="10">
                                                        <option value="-1">Nessuno</option>
                                                        <option value="0" <?php echo((isset($portfolio) && $portfolio->getTraduzioneTedesco()==0) ? "selected" : "")?>>Questa occorrenza</option>
                                                        <?php
                                                            $queryComponentiDaMostrare = "SELECT * FROM geec_portfolio  WHERE id != {$idPortfolio}";
                                                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                                            while($portfolioTmp = $risComponenti->fetch_assoc()) {
                                                                $selezionato = "";
                                                                if((isset($portfolio) && $portfolio->getTraduzioneTedesco()==$portfolioTmp["id"])) {
                                                                    $selezionato = "selected";
                                                                }
                                                                echo"<option value=\"{$portfolioTmp["id"]}\" $selezionato >{$portfolioTmp["nome"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group col">
                                                    <label for="metadescription">Francese</label>
                                                    <select name="traduzioneFrancese" class="selectpicker" data-width="100%" data-live-search="true" data-size="10">
                                                        <option value="-1">Nessuno</option>
                                                        <option value="0" <?php echo((isset($portfolio) && $portfolio->getTraduzioneFrancese()==0) ? "selected" : "")?>>Questa occorrenza</option>
                                                        <?php
                                                            $queryComponentiDaMostrare = "SELECT * FROM geec_portfolio  WHERE id != {$idPortfolio}";
                                                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                                            while($portfolioTmp = $risComponenti->fetch_assoc()) {
                                                                $selezionato = "";
                                                                if((isset($portfolio) && $portfolio->getTraduzioneFrancese()==$portfolioTmp["id"])) {
                                                                    $selezionato = "selected";
                                                                }
                                                                echo"<option value=\"{$portfolioTmp["id"]}\" $selezionato >{$portfolioTmp["nome"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group col">
                                                    <label for="metadescription">Spagnolo</label>
                                                    <select name="traduzioneSpagnolo" class="selectpicker" data-width="100%" data-live-search="true" data-size="10">
                                                        <option value="-1">Nessuno</option>
                                                        <option value="0" <?php echo((isset($portfolio) && $portfolio->getTraduzioneSpagnolo()==0) ? "selected" : "")?>>Questa occorrenza</option>
                                                        <?php
                                                            $queryComponentiDaMostrare = "SELECT * FROM geec_portfolio  WHERE id != {$idPortfolio}";
                                                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                                            while($portfolioTmp = $risComponenti->fetch_assoc()) {
                                                                $selezionato = "";
                                                                if((isset($portfolio) && $portfolio->getTraduzioneSpagnolo()==$portfolioTmp["id"])) {
                                                                    $selezionato = "selected";
                                                                }
                                                                echo"<option value=\"{$portfolioTmp["id"]}\" $selezionato >{$portfolioTmp["nome"]}</option>";
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <small class="form-text text-muted">È possibile associare a questo portoflio una traduzione per ciascuna lingua. L'ordine delle traduzioni seguirà quello del posizionamento degli elementi. <br>Per stabilire la lingua di questo porfolio seleziona "Questa occorrenza" nella lingua corrispondente</small>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <?php 
                            if(isset($portfolio)) {
                        ?>
                        
                            <div class="card mb-4 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#divCategoriePortfolio">
                                    <span class="card-title mr-2"> Categorie del portfolio</span>
                                </div>
                                <div id="divCategoriePortfolio" class="collapse">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-sm-4 col-xl-3 sticky-top align-self-start">
                                                <form>
                                                    <div class="mb-4 add-box">
                                                        <h6 class="mb-3"> Crea una nuova categoria </h6>
                                                        <div class="options-box">
                                                            <div class="form-group">
                                                                <label for="nome-voce-menu-1">Nome</label>
                                                                <input type="text" class="form-control" id="nomeCategoria" placeholder="Nome">
                                                            </div>
                                                            <button type="button" class="btn btn-primary float-right" value="Crea"  onclick="creaCategoriaPortfolio()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="col-sm-8 col-xl-9 mb-4 gerarchia-menu">
                                                <div id="elencoCategorie" class="row">
                                                    <?php 
                                                        $portfolio->stampaElencoCategorie();
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-4 col-xl-3 sticky-top align-self-start">
                                            <form>
                                                <div class="mb-4 add-box">
                                                    <h6 class="mb-3"> Aggiungi un elemento</h6>
                                                    <div class="options-box">
                                                        <div class="form-group">
                                                            <input type="text" id="titoloElemento" class="form-control" placeholder="Es.: Elemento 1">
                                                        </div>
                                                        <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElemento()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>

                                        <div id="divElencoElementi" class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
                                            <?php 
                                                $portfolio->stampaElementi();
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php
                            }
                        ?>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../include/modal/eliminaElemento.php";
        ?>
        <div class="modal fade" id="modalEliminaCategoria" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare la categoria?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeGruppoDaEliminare"></em></span>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="categoriaDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneCategoria()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modifica-categoria" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Modifica categoria</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                          <form>
                                <input type="text" class="d-none" id="idCategoriaDaModificare" name="id">

                                <div class="form-group">
                                    <label for="nome-voce-menu-1">Nome</label>
                                    <input type="text" class="form-control" id="nomeCategoriaModificare" name="nome" placeholder="Nome">
                                </div>
                          </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaCategoria()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>
        
        <?php  
            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $portfolio->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $portfolio->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var titolo = $('#titoloElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerContenuti.php",
                    data:{
                        operazione:"creaElementoPortfolio",
                        idPortfolio:<?php echo $portfolio->getId() ?>,
                        titolo:titolo
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $portfolio->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaCategoriaPortfolio() {
                var nome = document.getElementById("nomeCategoria").value;
                if(nome.length<1) {
                    alert("Il campo è vuoto");
                }
                else {
                    $.ajax({
                        type:"POST",
                        url:"controller/controllerComponente.php",
                        data:{
                            operazione:"creaCategoriaPortfolio",
                            idPortfolio:<?php echo(isset($portfolio) ? $portfolio->getId() : "0") ?>,
                            nome:nome
                        },
                        success:function(esito) {
                            if(esito=="ok") {
                                aggiornaElencoCategorie();
                            }
                            else {
                                alert(esito);
                            }
                        },
                        error: function(xhr,status,error) {
                            alert(status+" "+error);
                        }
                    });
                }
            }
            
            function eliminaCategoria(id,nomeElemento) {
                $('#categoriaDaEliminare').val(id);
                $('#nomeGruppoDaEliminare').text(nomeElemento);
                $('#modalEliminaCategoria').modal('show');
            }
            
            function eseguiEliminazioneCategoria() {
                var id = $('#categoriaDaEliminare').val();
    
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerCategorie.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            document.getElementById("categoria"+id).className = "d-none";
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
    
                $('#modalEliminaCategoria').modal('hide');
            }
            
            function modificaCategoria(id,nome) {
                $('#idCategoriaDaModificare').val(id);
                $('#nomeCategoriaModificare').val(nome);
                $('#modifica-categoria').modal('show');
            }
       
            function eseguiModificaCategoria() {
                var id    = $('#idCategoriaDaModificare').val();
                var nome  = $('#nomeCategoriaModificare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"modificaCategoriaPortfolio",
                        idCategoria:id,
                        nome:nome
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaElencoCategorie();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaElencoCategorie() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElencoCategorie",
                        id:<?php echo(isset($portfolio) ? $portfolio->getId() : 0)?>
                    },
                    success:function(result) {
                        document.getElementById("elencoCategorie").innerHTML = result;
                        $('#modifica-categoria').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
